<?php
defined('_JEXEC') or die('Restricted access');
require_once( JPATH_ROOT.DS.'components'.DS.'com_community'.DS.'libraries'.DS.'core.php');

class plgCommunityAnnonces extends CApplications
{

	function __construct(& $subject, $config)
	{
            $this->_user    = CFactory::getRequestUser();
            $this->_my      = CFactory::getUser();
            parent::__construct($subject, $config);
	}

        function onProfileDisplay()
        {
            // Load language
            JPlugin::loadLanguage( 'plg_annonces', JPATH_ADMINISTRATOR );

            //add CSS
            $document =& JFactory::getDocument();
            $css      = JURI::base().'plugins/community/annonces/style.css';
            $document->addStyleSheet($css);

            //get annonce for current user
            $annonces = $this->_getAnnoncesByUser();

			$userId = $this->_user->id;
			$userName = $this->_user->getDisplayName();
			$my			= CFactory::getUser();
			$isOwner	= ($my->id == $userId ) ? true : false;
			$itemId = $this->getItemid();

            //cache system :
            $mainframe =& JFactory::getApplication();
            $caching = $this->params->get('cache', 1);
            if($caching){
                $caching = $mainframe->getCfg('caching');
            }

            $cache =& JFactory::getCache('plgCommunityAnnonces');
            $cache->setCaching($caching);

            //define render callback
            $callback = array('plgCommunityAnnonces', '_getAnnoncesListHTML');

            //run
            return $cache->call($callback, $annonces, $userId, $userName, $isOwner, $itemId);
        }

        function _getAnnoncesByUser(){
            $db =& JFactory::getDBO();

            $query = 'SELECT * FROM #__annonces AS an
                WHERE an.approuved = 1 AND an.published = 1 AND vendeurId = '.$this->_user->id;

            $db->setQuery( $query );

            $result = $db->loadObjectList();

            return $result;
        }

	/**
	 * Return itemid for Annonces
	 */	 	
	function getItemid()
	{
		$db =& JFactory::getDBO();
		$Itemid = 0;

    	if ($Itemid < 1)
		{
        	$db->setQuery("SELECT id FROM #__menu WHERE link LIKE '%index.php?option=com_annonces%' AND published = 1");
        	$Itemid = $db->loadResult();

        	if ($Itemid < 1)
			{
         	   $Itemid = 0;
        	}
    	}
	    
	    return $Itemid;
	}


        function _getAnnoncesListHTML($annonces, $userId, $userName, $isOwner, $itemId){
            ob_start();
			if($isOwner) {
			?>
			<div class="app-box-menu">
				<a href="<?php echo JRoute::_('index.php?option=com_annonces&view=edit&Itemid=' . $itemId);?>">
				<?php echo JText::_('PLG_ANNONCE ADD NEW'); ?>
				</a>
			</div>
			<div style="clear:both"></div>
			<?php
			}
			
            if(empty($annonces)){
			?>
			<div class="icon-nopost">
				<img src="<?php echo JURI::base(); ?>plugins/community/annonces/annonce.png" alt="" />
			</div>
			<div class="content-nopost">
				<?php echo JText::_('PLG_ANNONCES EMPTY');?>
			</div>
			<div style="clear:both"></div>
			<?php
            }
			?>
            <table class="community-annonces-table">
			<?php
			foreach($annonces as $annonce):
			?>
			<tr>
				<td class="ann-icon">
					<img src="<?php echo JURI::base(); ?>plugins/community/annonces/annonce.png" alt="" />
				</td>
				<td class="ann-title">
                  	<a href="<?php echo JRoute::_('index.php?option=com_annonces&view=annonce&id='.$annonce->id);?>">
					<?php echo $annonce->objet; ?>
					</a>
              </td>
              <td class="ann-update">
				<?php if( $isOwner ): ?>
				<span>
				<a class="editprofilelink" href="<?php echo JRoute::_('index.php?option=com_annonces&view=edit&id='.$annonce->id . '&Itemid=' . $itemId);?>"><?php echo JText::_('PLG_ANNONCES UPDATE'); ?></a>
				</span>
				<?php endif; ?>
				</td>
            </tr>
            <tr>
            	<td></td>
            	<td class="ann-venue">
					<?php echo $annonce->description; ?>
            	</td>
            	<td></td>
            </tr>
			<?php
			endforeach; ?>
          	</table>
          	<?php
            $content = ob_get_contents();
            ob_end_clean();
            return $content;
        }


}