<?php

/**

* @version		$Id: vote.php 14401 2010-01-26 14:10:00Z louis $

* @package		Joomla

* @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.

* @license		GNU/GPL, see LICENSE.php

* Joomla! is free software. This version may have been modified pursuant

* to the GNU General Public License, and as distributed it includes or

* is derivative of works licensed under the GNU General Public License or

* other free or open source software licenses.

* See COPYRIGHT.php for copyright notices and details.

* Edited by Giochigratisonline.eu thanks to Lino Maglione.

*/



// no direct access

defined( '_JEXEC' ) or die( 'Restricted access' );



$mainframe->registerEvent( 'onBeforeDisplayContent', 'plgContentVoteSEO' );



function plgContentVoteSEO(&$row,&$params,$page=0){

	$uri = &JFactory::getURI();

	$id = $row->id;

	$plugin = &JPluginHelper::getPlugin('content','voteseo');

	$parameters = new JParameter($plugin->params);		

	$view_mode = $parameters->get('display_as', 0);

	$avg_mode = $parameters->get('average', 0);

	$format_mode = $parameters->get('format_mode', 1);	

	$html 	= '';

	if (isset($row->rating_count) && $params->get( 'show_vote' ) && !$params->get('popup')){

		JPlugin::loadLanguage('plg_content_vote');

		$html .= '<form method="post" action="' . $uri->toString( ) . '">';

		$img = '';		

		if($view_mode){

			$starImageOn 	= '/plugins/content/voteseo/rating_star.png';

			$starImageOff 	= '/plugins/content/voteseo/rating_star_blank.png';

		}

		else{

			$starImageOn 	= '/plugins/content/voteseo/rating_starstar.png';

			$starImageOff 	= '/plugins/content/voteseo/rating_starstar_blank.png';

		}

		$size = getimagesize(JPath::clean(JPATH_ROOT.DS.$starImageOn));		

		$starImageOn = "<img src = '".$starImageOn."' width='".$size[0]."' height='".$size[1]."' alt='' title='' />";

		$size = getimagesize(JPath::clean(JPATH_ROOT.DS.$starImageOff));

		

		$starImageOff = "<img src = '".$starImageOff."' width='".$size[0]."' height='".$size[1]."' alt='' title='' />";

		

		for ($i=0; $i < $row->rating; $i++)

			$img .= $starImageOn;

		for ($i=$row->rating; $i < 5; $i++)

			$img .= $starImageOff;

		$html .= '<span class="content_rating">';

		$html .= JText::_( 'User Rating' ) .':'. $img .'&nbsp;/&nbsp;';

		$html .= intval( $row->rating_count );

		$html .= "</span>\n<br />\n";

		if (!$params->get( 'intro_only' )){

			$html .= '<span class="content_vote">';

			$html .= JText::_( 'Poor' );

			$html .= '<input type="radio" alt="vote 1 star" name="user_rating" value="1" />';

			$html .= '<input type="radio" alt="vote 2 star" name="user_rating" value="2" />';

			$html .= '<input type="radio" alt="vote 3 star" name="user_rating" value="3" />';

			$html .= '<input type="radio" alt="vote 4 star" name="user_rating" value="4" />';

			$html .= '<input type="radio" alt="vote 5 star" name="user_rating" value="5" checked="checked" />';

			$html .= JText::_( 'Best' );

			$html .= '&nbsp;<input class="button" type="submit" name="submit_vote" value="'. JText::_( 'Rate' ) .'" />';

			$html .= '<input type="hidden" name="task" value="vote" />';

			$html .= '<input type="hidden" name="option" value="com_content" />';

			$html .= '<input type="hidden" name="cid" value="'. $id .'" />';

			$html .= '<input type="hidden" name="url" value="'.  $uri->toString( ) .'" />';

			$html .= '</span>';

		}

		$html .= '</form>';		

		$ave = $row->rating;

		if($avg_mode){

			$s = "SELECT * FROM jos_content_rating WHERE content_id = ".$id;

			$db = &JFactory::getDBO();	

			$db->setQuery($s);

			if(!$db->query()) {

				JError::raiseError( 500, $db->stderr());

			}

			$list = $db->loadAssocList();

			if(isset($list[0]['rating_sum']))

				$ave = intval($list[0]['rating_sum'] / $list[0]['rating_count'] * 100) / 100;

		}

		switch($format_mode){

			case 1:

				$html .= '<div class="hreview-aggregate" style="display:none;">';

				$html .= '<span class="item">';

				$html .= '<span class="fn">'.$row->title.'</span>';

				$html .= '</span>';

				$html .= '<span class="rating">';

				$html .= '<span class="average">';

				$html .= $ave;

				$html .='</span> su';

				$html .= '<span class="best">5</span>';

				$html .= '</span>';

				$html .= 'basata su';

				$html .= '<span class="count">'.intval( $row->rating_count ).'</span> utenti.';

				$html .= '</div>';		

			break;

			case 0:			

				$html .= '<div itemscope itemtype="http://data-vocabulary.org/Review-aggregate" style="display:none;">';

				$html .= '<span itemprop="itemreviewed">'.$row->title.'</span>';

				$html .= '<span itemprop="rating" itemscope itemtype="http://data-vocabulary.org/Rating">';

				$html .= '<span itemprop="average">'.$ave.'</span>';

				$html .= 'su <span itemprop="best">5</span>';

				$html .= '</span>';

				$html .= '<span itemprop="count">'.intval( $row->rating_count ).'</span> utenti.';

				$html .= '</div>';

			break;

			case 2:

				$html .= '<div xmlns:v="http://rdf.data-vocabulary.org/#" typeof="v:Review-aggregate" style="display:none;">';

				$html .= '<span property="v:itemreviewed">'.$row->title.'</span>';

				$html .= '<span rel="v:rating">';

				$html .= '<span typeof="v:Rating">';

				$html .= '<span property="v:average">'.$ave.'</span>';

				$html .= 'su';

				$html .= '<span property="v:best">5</span>';

				$html .= '</span>';

				$html .= '</span>';

				$html .= 'basata su'; 

				$html .= '<span property="v:count">'.intval( $row->rating_count ).'</span> utenti.';

				$html .= '</div>';

			break;

		}

	}

	return $html;

}