<?php
/**
* @version $Id: admin.reviews.class.php 4913 2009-03-01 18:35:06Z Sigrid Suski $
* @package: Sigsiu Online Business Index 2
* ===================================================
* @author
* Name: Sigrid & Radek Suski, Sigsiu.NET
* Email: sobi@sigsiu.net
* Url: http://www.sigsiu.net
* ===================================================
* @copyright Copyright (C) 2007-2009 Sigsiu.NET (http://www.sigsiu.net). All rights reserved.
* @license see http://www.gnu.org/copyleft/gpl.html GNU/GPL.
* SOBI2 is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation.
*/

defined( '_SOBI2_' ) || ( trigger_error("Restricted access", E_USER_ERROR) && exit() );

sobi2Config::import("plugins|reviews|reviews.class");

class sobi_reviews_adm extends sobi_reviews {

    function sobi_reviews_adm() {
    	$this->sobi_reviews();
    }
    
    /**
     * Alle Eintrge in der Tabelle im Entry-Tab in DB schreiben
     *
     * @param unknown_type $input
     * @param unknown_type $sobi2Id
     * @return unknown
     */
    function update($input, $sobi2Id) 
    {
    	$config =& adminConfig::getInstance();
		$database =& $config->getDb();
    	$revTextes = sobi2Config::request( $_REQUEST, 'revText', array(0));
    	$revTitles = sobi2Config::request( $_REQUEST, 'revTitle', array(0));
    	$revVotes = sobi2Config::request( $_REQUEST, 'revVote', array(0));
    	$revids = sobi2Config::request( $_REQUEST, 'revid', array(0));
    	$revDel = sobi2Config::request( $_REQUEST, 'revDel', array(0));
		$revarr = array_combine($revids,$revTextes);
		$titlarr = array_combine($revids,$revTitles);
		$votearr = array_combine($revids,$revVotes);
		
		$count = count($revarr);
		for($i = 0; $i < $count;) {
			$published = (int)sobi2Config::request( $_REQUEST, "revPubl{$revids[$i]}", 0);

			if (in_array($revids[$i],$revDel))
				echo $statement = "DELETE FROM `#__sobi2_plugin_reviews` WHERE `revid` = '{$revids[$i]}'";

			else {
				$title = $database->getEscaped($titlarr[$revids[$i]]);
				$review = $database->getEscaped($revarr[$revids[$i]]);
				$vote = (int)$votearr[$revids[$i]];
				if ($vote > 5)
					$vote = 5;	//limitieren auf maximum
				
				$statement = "UPDATE `#__sobi2_plugin_reviews` SET " .
							"`title` = '{$title}', " .
							"`review` = '{$review}', " .
							"`vote` = '{$vote}', " .
							"`published` = '{$published}', " .
							"`updateInfo` = NULL " .
							" WHERE `revid` = '{$revids[$i]}'";
			}
			$database->setQuery($statement);
			$database->query();
			$i++;
		}
    	return $input;
    }

    
    /**
     * Alle Eintrge in der Tabelle im Entry-Tab im Backend darstellen
     *
     * @param int $sobi2Id
     */
    function getReviews($sobi2Id) 
    { 
		$config =& adminConfig::getInstance();
		$database =& $config->getDb();

		//count all for this entry
		$query = "SELECT COUNT(*) FROM `#__sobi2_plugin_reviews` WHERE (`itemid` = {$sobi2Id})";
		$database->setQuery( $query );
		$count = $database->loadResult();
		
		$limit = 15;	//number for backend pagination
		$no_pages = ceil($count / $limit);
		$akt_page = sobi2Config::request($_REQUEST, 'reviewpage', 1);
		$start = ($akt_page-1) * $limit;
		
    	$query = "SELECT * FROM `#__sobi2_plugin_reviews` WHERE (`itemid` = {$sobi2Id}) ORDER BY `added` {$this->ordering} LIMIT {$start} , $limit";
		$database->setQuery( $query );
		$reviews = $database->loadObjectList();
		
 		if(count($reviews)) {
			?>
			  <table class="SobiAdminForm" style="width: 100%;" border="1">
			    <tr>
			    	<th style="text-align:center; vertical-align:top; width:5px;">RevID</th>
			    	<th style="text-align:center; vertical-align:top; width:5px;"><?php echo _S_2_REV_ADM_DEL; ?></th>
			    	<th style="text-align:center; vertical-align:top; width:45px;"><?php echo _S_2_REV_ADM_DATE; ?></th>
			    	<th style="text-align:center; vertical-align:top; width:70px;"><?php echo _S_2_REV_ADM_AUTHOR; ?></th>
			    	<th style="text-align:center; vertical-align:top; width:60px;"><?php echo _S_2_REV_REVIEW; ?></th>
			    	<th style="text-align:center; vertical-align:top; width:20px;"><?php echo _S_2_REV_VOTE; ?></th>
			    	<th style="text-align:center; vertical-align:top; width:85px;"><?php echo _S_2_REV_ADM_PUBL; ?></th>
		    	</tr>
			<?php
			$c = 0;
			foreach($reviews as $rev) {
				$rowStyle = $c%2 ? 'class="row1"' : 'class="row0"';
				$rev->title = stripslashes($rev->title);
				$rev->review = stripslashes($rev->review);
				$rev->username = stripslashes($rev->username);
				?>
				 <tr <?php echo $rowStyle; ?>>
					<td  style="vertical-align:top; text-align:center;"><?php echo $rev->revid; ?></td>
					<td  style="vertical-align:top; text-align:center; width:5px;">
						<input type="checkbox" name="revDel[]" value="<?php echo $rev->revid; ?>" onclick="if(this.checked == true) alert('<?php echo _S_2_REV_JS_DEL_CONF ;?>')"/>
						<input type="hidden" name="revid[]" value="<?php echo $rev->revid; ?>"/>
					</td>
					<td  style="vertical-align:top;"><?php echo $rev->added; ?></td>
					<td  style="vertical-align:top;">
					<?php if($rev->email) { ?>
						<a href="mailto:<?php echo $rev->email; ?>"><?php echo $rev->username; ?></a>
					<?php } else { ?>
						<?php 
						if (empty($rev->username))
							echo _S_2_REV_AUTHOR_EMPTY;
						else 
							echo $rev->username; } ?>
						<br/>
						<?php echo $rev->ip; ?>
					</td>
					<td  style="vertical-align: top;">
						<?php 
						$style = null;
						if (empty($rev->title) && empty($rev->review)) {
							echo _S_2_REV_REVIEW_EMPTY;
							$style = 'style="display:none;"';
						} ?>
						<input type="text" class="text_area" name="revTitle[]" <?php echo $style; ?> value="<?php echo $rev->title; ?>" size="60" maxlength="60"/><br/>
						<textarea class="text_area" name="revText[]" <?php echo $style; ?> rows="6" cols="60"><?php echo $rev->review; ?></textarea>
					</td>
					<td  style="vertical-align:top; text-align:center;">
						<input type="text" class="text_area" name="revVote[]" value="<?php echo $rev->vote; ?>" size="4" maxlength="4" style="text-align:center;"/>
					</td>
					<td style="vertical-align: top;"><?php echo sobiHTML::yesnoRadioList( 'revPubl'.$rev->revid, 'class="inputbox"', $rev->published); ?></td>
				 </tr>
				<?php
				$c++;
			}
			?></table><?php
		}

		//navigation
		if ($no_pages) {
			$returntask = sobi2Config::request($_REQUEST,'returnTask');
			$catId = (int)sobi2Config::request($_REQUEST,'catid');

			if (class_exists( "JDatabase" )) { //Joomla 1.5
				echo '<div style="text-align:center;"><div class="pagination">';
				if ($akt_page == 1) {
					echo "<div class=\"button2-right off\"><div class=\"start\"><span>"._S_2_ADM_PAGINATION_START."</span></div></div>";
					echo "<div class=\"button2-right off\"><div class=\"prev\"><span>"._S_2_ADM_PAGINATION_PREV."</span></div></div>";
				}
				else {
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage=1";
					echo "<div class=\"button2-right\"><div class=\"start\"><a href=\"{$link}\" title=\""._S_2_ADM_PAGINATION_START."\">"._S_2_ADM_PAGINATION_START."</a></div></div>";
					$prevpage = $akt_page-1;
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$prevpage}";
					echo "<div class=\"button2-right\"><div class=\"prev\"><a href=\"{$link}\" title=\""._S_2_ADM_PAGINATION_PREV."\">"._S_2_ADM_PAGINATION_PREV."</a></div></div>";
				}
				echo "<div class=\"button2-left\"><div class=\"page\">";
				for ($page=1; $page<=$no_pages; $page++) {
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$page}";
					if ($page == $akt_page)
						echo '<span>'.$page.'</span>';
					else
						echo "<a href=\"{$link}\" title=\"{$page}\">".$page.'</a>';
				}
				echo '</div></div>';
				if ($akt_page == $no_pages) {
					echo "<div class=\"button2-left off\"><div class=\"next\"><span>"._S_2_ADM_PAGINATION_NEXT."</span></div></div>";
					echo "<div class=\"button2-left off\"><div class=\"end\"><span>"._S_2_ADM_PAGINATION_END."</span></div></div>";
				}
				else {
					$nextpage = $akt_page+1;
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$nextpage}";
					echo "<div class=\"button2-left\"><div class=\"next\"><a href=\"{$link}\" title=\""._S_2_ADM_PAGINATION_NEXT."\">"._S_2_ADM_PAGINATION_NEXT."</a></div></div>";
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$no_pages}";
					echo "<div class=\"button2-left\"><div class=\"end\"><a href=\"{$link}\" title=\""._S_2_ADM_PAGINATION_END."\">"._S_2_ADM_PAGINATION_END."</a></div></div>";
				}
				echo "<div class=\"limit\">"._S_2_ADM_PAGINATION_PAGE." {$akt_page} "._S_2_ADM_PAGINATION_OF." {$no_pages}</div>";
				echo '</div></div><br/>';
			}
			//Joomla 1.0, Mambo und Co
			else {
				echo '<div style="text-align:center;"><table class="adminlist"><tbody><tr><th colspan="3">';
				if ($akt_page == 1) {
					echo '<span class="pagenav">'._S_2_REV_PAGENAV_START.'</span>';
					echo '<span class="pagenav"> '._S_2_REV_PAGENAV_PREV.'</span>';
				}
				else {
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage=1";
					echo "<span class=\"pagenav\"><a href=\"{$link}\" title=\""._S_2_REV_PAGENAV_START_TITLE."\">"._S_2_REV_PAGENAV_START."</a></span>";
					$prevpage = $akt_page-1;
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$prevpage}";
					echo "<span class=\"pagenav\"> <a href=\"{$link}\" title=\""._S_2_REV_PAGENAV_PREV_TITLE."\">"._S_2_REV_PAGENAV_PREV."</a></span>";
				}
				for ($page=1; $page<=$no_pages; $page++) {
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$page}";
					if ($page == $akt_page)
						echo '<span class="pagenav"> '.$page.' </span>';
					else
						echo "<span class=\"pagenav\"><a href=\"{$link}\" title=\"{$page}\"><strong> ".$page.' </strong></a></span>';
				}
				if ($akt_page == $no_pages) {
					echo '<span class="pagenav">'._S_2_REV_PAGENAV_NEXT.' </span>';
					echo '<span class="pagenav">'._S_2_REV_PAGENAV_END.'</span>';
				}
				else {
					$nextpage = $akt_page+1;
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$nextpage}";
					echo "<span class=\"pagenav\"><a href=\"{$link}\" title=\""._S_2_REV_PAGENAV_NEXT_TITLE."\">"._S_2_REV_PAGENAV_NEXT."</a> </span>";
					$link = "index2.php?option=com_sobi2&amp;task=edit&amp;sobi2Id={$sobi2Id}&amp;hidemainmenu=1&amp;returnTask={$returntask}&amp;catid={$catId}&amp;reviewpage={$no_pages}"; 
					echo "<span class=\"pagenav\"><a href=\"{$link}\" title=\""._S_2_REV_PAGENAV_END_TITLE."\">"._S_2_REV_PAGENAV_END."</a></span>";
				}
				echo '<br/><span class="pagenav">&nbsp;'._S_2_ADM_PAGINATION_PAGE." {$akt_page} "._S_2_ADM_PAGINATION_OF." {$no_pages}</span>";
				echo '</th></tr></table></div><br/>';
			}
		}
    }
    
    
	/**
	 * Review & Ratings Tab in entry back-end
	 *
	 * @param int $sid
	 * @param sobiTabs $tabs
	 */
	function addEditEntryTab($sid, $tabs)
	{
		$tabs->startTab($this->name,"revandrat");
    	echo '<div style="text-align:left;">';
    	echo _S_2_REV_VOTES_NUM;
    	echo $this->countVotes( $sid );
		echo '<br/>'._S_2_REV_VOTING_RESULTS;
    	echo $this->showRating($sid, true);
    	echo '<br/><br/>';
    	
   		$this->getReviews($sid);
		
		echo '</div>';
		$tabs->endTab();
	}
	
	/**
	 * @param array $fields
	 * @param int $sobiId
	 */
	function editFormStart($sobiId, &$fields)
	{
		return null;
	}
	/**
	 * @param array $fields
	 * @param int $sobiId
	 */
	function editForm($sobiId)
	{
		return null;
	}

	/**
	 * Die Konfiguration des Plugins in der DB speichern
	 *
	 */
	function saveConfig() 
	{
		$config =& adminConfig::getInstance();
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RcountInListing',$this->countInListing )),"RcountInListing","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RshowUpdatesInfo',$this->showUpdatesInfo )),"RshowUpdatesInfo","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RshowMails',$this->showMails )),"RshowMails","sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'Rordering',$this->ordering ),"Rordering","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RshowIndVotes',$this->showIndVotes )),"RshowIndVotes","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RformPosition',$this->formPosition )),"RformPosition","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'Ranonymous',$this->anonymous )),"Ranonymous","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RmultiRev',$this->multiRev )),"RmultiRev","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RrevsOn',$this->revsOn )),"RrevsOn","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RvotesOn',$this->votesOn )),"RvotesOn","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'Rautopublish',$this->autopublish )),"Rautopublish","sobi_reviews");

    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RnotifyReviewAuthor',$this->notifyReviewAuthor )),"RnotifyReviewAuthor","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RnotifyEntryAuthor',$this->notifyEntryAuthor )),"RnotifyEntryAuthor","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RnotifyAdmin',$this->notifyAdmin )),"RnotifyAdmin","sobi_reviews");
    	
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RnotifyReviewAuthorTempl',$this->notifyReviewAuthorTempl),"RnotifyReviewAuthorTempl","sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RnotifyEntryAuthorTempl',$this->notifyEntryAuthorTempl),"RnotifyEntryAuthorTempl","sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RnotifyAdminTempl',$this->notifyAdminTempl),"RnotifyAdminTempl","sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RnotifyReviewAuthorSubj',$this->notifyReviewAuthorSubj),"RnotifyReviewAuthorSubj","sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RnotifyEntryAuthorSubj',$this->notifyEntryAuthorSubj),"RnotifyEntryAuthorSubj","sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RnotifyAdminSubj',$this->notifyAdminSubj),"RnotifyAdminSubj","sobi_reviews");

    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'Rlimit',$this->limit )),"Rlimit","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request( $_POST, 'RlistingLimit',$this->listingLimit )),"RlistingLimit","sobi_reviews");
    	$this->listingVotesLimit = intval(sobi2Config::request( $_POST, 'RlistingVotesLimit', 16));
    	$this->listingVotesLimit = ($this->listingVotesLimit==0)?1:$this->listingVotesLimit;
    	$config->setValueInDB($this->listingVotesLimit, "RlistingVotesLimit","sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RlistingExcludeCats',$this->listingExcludeCat ),"RlistingExcludeCats","sobi_reviews");
    	$this->infoText = sobi2Config::request($_POST, 'RinfoText', $this->infoText, 0x0002);
    	$config->setValueInDB($this->infoText, "RinfoText","sobi_reviews");
    	$config->setValueInDB(intval(sobi2Config::request($_POST, 'RshowUsername', $this->showUsername)), "RshowUsername", "sobi_reviews");
    	$config->setValueInDB(sobi2Config::request( $_POST, 'RdateFormat',$this->dateFormat ),"RdateFormat","sobi_reviews");
	}
    
    /**
     * Plugin Konfiguration
     *
     */
    function config() {
	?>
 	<table class="SobiAdminForm" width="100%" border="1">
		<tr>
			<th><?php echo $this->name;?></th>
		</tr>
		<tr>
			<td>
				<?php $this->settings(); ?>
			</td>
		</tr>
	</table>
	<?php
    }

    /**
     * Anzeige aller Einstellungen im Backend
     *
     */
    function settings() 
    {
		$revSel = array();
		$revSel[] = sobiHTML::makeOption( 'DESC', _S_2_REV_ADM_SORT_DESC);
		$revSel[] = sobiHTML::makeOption( 'ASC', _S_2_REV_ADM_SORT_ASC);
		$revSelList = sobiHTML::selectList( $revSel, 'Rordering', 'size="1" class="inputbox"', 'value', 'text', $this->ordering );
		$formPos = array();
		$formPos[] = sobiHTML::makeOption( '1',_S_2_REV_ADM_FORM_POS_AFTER );
		$formPos[] = sobiHTML::makeOption( '2', _S_2_REV_ADM_FORM_POS_BEFORE);
		$formPosList = sobiHTML::selectList( $formPos, 'RformPosition', 'size="1" class="inputbox"', 'value', 'text', $this->formPosition );

	?>
	<table class="SobiAdminForm" width="100%">
		<tr>
			<th style="text-align:left; width: 30%;"><?php echo _S_2_REV_ADM_CONFIG_HEADER; ?></th>
		</tr>
	</table>

	<table class="SobiAdminForm" width="100%">
     <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_ALLOW_REV_EXPL),addslashes(_S_2_REV_ADM_ALLOW_REV),'','',_S_2_REV_ADM_ALLOW_REV, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RrevsOn', 'class="inputbox"', $this->revsOn); ?></td>
    </tr>

     <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_ALLOW_VOTE_EXPL),addslashes(_S_2_REV_ADM_ALLOW_VOTE),'','',_S_2_REV_ADM_ALLOW_VOTE, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RvotesOn', 'class="inputbox"', $this->votesOn); ?></td>
    </tr>

    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_ALLOW_ANO_EXPL),addslashes(_S_2_REV_ADM_ALLOW_ANO),'','',_S_2_REV_ADM_ALLOW_ANO, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'Ranonymous', 'class="inputbox"', $this->anonymous); ?></td>
    </tr>

    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_ALLOW_MULTI_EXPL),addslashes(_S_2_REV_ADM_ALLOW_MULTI),'','',_S_2_REV_ADM_ALLOW_MULTI, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RmultiRev', 'class="inputbox"', $this->multiRev); ?></td>
    </tr>

    <!-- Reviews Settings -->
    <tr>
		<th style="text-align:left;" colspan="2"><?php echo _S_2_REV_ADM_REVIEWS_SETTINGS; ?></th>
	</tr>
    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_AUTOPUBLISH_EXPL),addslashes(_S_2_REV_ADM_AUTOPUBLISH),'','',_S_2_REV_ADM_AUTOPUBLISH, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'Rautopublish', 'class="inputbox"', $this->autopublish); ?></td>
    </tr>

    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_SHOW_IND_VOTES_EXPL),addslashes(_S_2_REV_ADM_SHOW_IND_VOTES),'','',_S_2_REV_ADM_SHOW_IND_VOTES, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RshowIndVotes', 'class="inputbox"', $this->showIndVotes); ?></td>
    </tr>

    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_USERNAME_EXPL),addslashes(_S_2_REV_ADM_USERNAME),'','',_S_2_REV_ADM_USERNAME, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RshowUsername', 'class="inputbox"', $this->showUsername); ?></td>
    </tr>

    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_SHOW_MAILS_EXPL),addslashes(_S_2_REV_ADM_SHOW_MAILS),'','',_S_2_REV_ADM_SHOW_MAILS, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RshowMails', 'class="inputbox"', $this->showMails); ?></td>
    </tr>

    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_SHOW_UPDATE_INFO_EXPL),addslashes(_S_2_REV_ADM_SHOW_UPDATE_INFO),'','',_S_2_REV_ADM_SHOW_UPDATE_INFO, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RshowUpdatesInfo', 'class="inputbox"', $this->showUpdatesInfo); ?></td>
    </tr>

    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_COUNT_LISTING_EXPL),addslashes(_S_2_REV_ADM_COUNT_LISTING),'','',_S_2_REV_ADM_COUNT_LISTING, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RcountInListing', 'class="inputbox"', $this->countInListing); ?></td>
    </tr>

    <tr class="row0">
      <td valign="top" width="30%">
      		<?php echo _S_2_REV_ADM_FORM_POS;?>
      </td>
      <td valign="top" width="70%"><?php echo $formPosList; ?></td>
    </tr>

    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_LIMIT_EXPL),addslashes(_S_2_REV_ADM_LIMIT),'','',_S_2_REV_ADM_LIMIT, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:center;" name="Rlimit" value="<?php echo $this->limit; ?>" size="5" maxlength="10"/>
      </td>
    </tr>

    <tr class="row0">
      <td valign="top" width="30%">
      		<?php echo _S_2_REV_ADM_SORTBY;?>
      </td>
      <td valign="top" width="70%"><?php echo $revSelList; ?></td>
    </tr>

    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_DATEFORMAT_EXPL),addslashes(_S_2_REV_ADM_DATEFORMAT),'','',_S_2_REV_ADM_DATEFORMAT, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:center;" name="RdateFormat" value="<?php echo $this->dateFormat; ?>" size="20" maxlength="20"/>
      </td>
    </tr>

     <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_TEXT_EXPL),addslashes(_S_2_REV_ADM_TEXT),'','',_S_2_REV_ADM_TEXT, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%">
      <textarea class="text_area" style="text-align:left;width:400px;height:100px;" name="RinfoText"><?php echo $this->infoText; ?></textarea>
      </td>
    </tr>

   <!-- Email Settings -->
    <tr>
		<th style="text-align:left;" colspan="2"><?php echo _S_2_REV_ADM_EMAIL_SETTINGS; ?></th>
	</tr>
	<tr><td colspan="2"><?php echo _S_2_REV_ADM_EMAIL_EXPLANATION ?></td></tr>
    <tr class="row1">
      <td valign="top" width="30%">
      		<?php echo _S_2_REV_ADM_NOT_ADM;?>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RnotifyAdmin', 'class="inputbox"', $this->notifyAdmin); ?></td>
    </tr>
    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo _S_2_REV_ADM_NOT_ADM_SUBJ;?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:left; width:400px;" name="RnotifyAdminSubj" value="<?php echo $this->notifyAdminSubj; ?>" maxlength="100"/>
      </td>
    </tr>
   <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo _S_2_REV_ADM_NOT_ADM_TEMPL; ?>
      	</span>
      </td>
      <td valign="top" width="70%">
      <textarea class="text_area" style="text-align:left;width:400px;height:70px;" name="RnotifyAdminTempl"><?php echo $this->notifyAdminTempl; ?></textarea>
      </td>
    </tr>

    <tr class="row0">
      <td valign="top" width="30%">
      		<?php echo _S_2_REV_ADM_NOT_AUTHOR;?>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RnotifyEntryAuthor', 'class="inputbox"', $this->notifyEntryAuthor); ?></td>
    </tr>
    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo _S_2_REV_ADM_NOT_AUTHOR_SUBJ;?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:left; width:400px;" name="RnotifyEntryAuthorSubj" value="<?php echo $this->notifyEntryAuthorSubj; ?>" maxlength="100"/>
      </td>
    </tr>
    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo _S_2_REV_ADM_NOT_AUTHOR_TEMPL; ?>
      	</span>
      </td>
      <td valign="top" width="70%">
      <textarea class="text_area" style="text-align:left;width:400px;height:70px;" name="RnotifyEntryAuthorTempl"><?php echo $this->notifyEntryAuthorTempl; ?></textarea>
      </td>
    </tr>

    <tr class="row1">
      <td valign="top" width="30%">
      		<?php echo _S_2_REV_ADM_NOT_WRITER;?>
      </td>
      <td valign="top" width="70%"><?php echo sobiHTML::yesnoRadioList( 'RnotifyReviewAuthor', 'class="inputbox"', $this->notifyReviewAuthor); ?></td>
    </tr>
    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo _S_2_REV_ADM_NOT_WRITER_SUBJ;?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:left; width:400px;" name="RnotifyReviewAuthorSubj" value="<?php echo $this->notifyReviewAuthorSubj; ?>" maxlength="100"/>
      </td>
    </tr>
    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo _S_2_REV_ADM_NOT_WRITER_TEMPL; ?>
      	</span>
      </td>
      <td valign="top" width="70%">
      <textarea class="text_area" style="text-align:left;width:400px;height:70px;" name="RnotifyReviewAuthorTempl"><?php echo $this->notifyReviewAuthorTempl; ?></textarea>
      </td>
    </tr>
    
    <!-- Listing Settings -->
    <tr>
		<th style="text-align:left;" colspan="2"><?php echo _S_2_REV_ADM_LISTING_SETTINGS; ?></th>
	</tr>
	<tr><td colspan="2"><?php echo _S_2_REV_ADM_LIST_EXPLANATION ?></td></tr>
    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_VOTES_LIMIT_EXPL),addslashes(_S_2_REV_ADM_VOTES_LIMIT),'','',_S_2_REV_ADM_VOTES_LIMIT, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:center;" name="RlistingVotesLimit" value="<?php echo $this->listingVotesLimit; ?>" size="5" maxlength="10"/>
      </td>
    </tr>
    <tr class="row0">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_LIST_LIMIT_EXPL),addslashes(_S_2_REV_ADM_LIST_LIMIT),'','',_S_2_REV_ADM_LIST_LIMIT, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:center;" name="RlistingLimit" value="<?php echo $this->listingLimit; ?>" size="5" maxlength="10"/>
      </td>
    </tr>
    <tr class="row1">
      <td valign="top" width="30%">
      	<span class="editlinktip">
      		<?php echo sobiHTML::toolTip(addslashes(_S_2_REV_ADM_VOTES_EXCL_CAT_EXPL),addslashes(_S_2_REV_ADM_VOTES_EXCL_CAT),'','',_S_2_REV_ADM_VOTES_EXCL_CAT, '#',0 );?>
      	</span>
      </td>
      <td valign="top" width="70%">
      	<input type="text" class="text_area" style="text-align:left;" name="RlistingExcludeCats" value="<?php echo $this->listingExcludeCat; ?>" size="20" maxlength="50"/>
      </td>
    </tr>
    
    <!-- Info -->
	<tr>
		<th style="text-align:left;" colspan="2"><?php echo _S_2_REV_ADM_INFO_TITLE; ?></th>
	</tr>
    <tr class="row1">
      <td valign="top" width="100%" colspan="2"><?php echo _S_2_REV_ADM_INFO_1 ?><br/><?php echo _S_2_REV_ADM_INFO_2 ?><br/><?php echo _S_2_REV_ADM_INFO_3 ?></td>
    </tr>

	</table>
	<?php
	}
}
?>
